# 最大值练习

利用员工信息表：

```sql
create table employee
(
    id     serial primary key,
    name   varchar(256),
    dept   varchar(256),
    salary decimal(12, 4)
);
```

Joe 做了一些关于 max 函数的练习，其中不正确的是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select id, dept, max(salary) as salary, name 
from employee
group by dept
```

可以得到每个部门工资最高的员工的全部信息。

## 选项

### A

```sql
select dept, max(salary) as salary
from employee
group by dept
```

可以得到每个部门的最高工资。

### B

```sql
select max(salary) as salary
from employee
```

可以得到全部员工中最高的工资。

### C

```sql
select dept, sum(salary)
from employee
group by dept
having max(salary) < 20000
```

可以得到员工最高工资不超过两万的部门及其总的工资开支

### D

```sql
select dept, min(salary)
from employee
group by dept
having max(salary) > 50000
```

可以得到员工最高工资超过五万的部门，及其最低工资的清单
